import numpy


# Color maps for each color blind mode.
# Each original color on the left is mapped to the one on the right (as good as possible).
mappings=dict(
	Deuteranopia=[
		(( 31, 168, 225), ( 20, 120, 240)),
		((237, 187,  15), (230, 180,  15)),
		((221,  27, 164), (180,  20,  20)),
		# (( 55, 193,  18), (240,  25,  25)),
		((255, 255, 255), (255, 255, 255)),
	],
	Protanopia=[
		(( 31, 168, 225), ( 10,  40, 255)),
		((237, 187,  15), (230, 180,  15)),
		# ((221,  27, 164), (120,  80,  20)),
		# ((221,  27, 164), (180,  20,  20)),
		((221,  27, 164), (100*0.9, 140*0.9, 180*0.9)),
		((255, 255, 255), (255, 255, 255)),
	],
	Tritanopia=[
		(( 31, 168, 225), ( 10, 120, 240)),
		((237, 187,  15), (190,  10,   0)),
		((221,  27, 164), (250, 230, 180)),
		(( 55, 193,  18), ( 20, 180, 180)),
		((255, 255, 255), (255, 255, 255)),
		((158, 224,  54), ( 50, 240, 220)),
	],
	Achromatopsia=[
		(( 31, 168, 225), ( 80,  80,  80)),
		((237, 187,  15), (240, 240, 240)),
		((221,  27, 164), (210, 210, 210)),
		(( 55, 193,  18), (160, 160, 160)),
		((255, 255, 255), (255, 255, 255)),
	],
)


# math stuff
def computeColorMatrix(colorMap):
	a=[]
	b=[]
	for p in colorMap:
		c=p[0]
		a.append([c[0], c[1], c[2], 0, 0, 0, 0, 0, 0])
		a.append([0, 0, 0, c[0], c[1], c[2], 0, 0, 0])
		a.append([0, 0, 0, 0, 0, 0, c[0], c[1], c[2]])
		for i in range(3):
			b.append(p[1][i])

	return numpy.linalg.lstsq(a, b)[0]


def formatColorMatrix(m, name):
	return ("\t{name} = {{\n"+
		"\t\t{: .3f}, {: .3f}, {: .3f}, 0, 0,\n"+
		"\t\t{: .3f}, {: .3f}, {: .3f}, 0, 0,\n"+
		"\t\t{: .3f}, {: .3f}, {: .3f}, 0, 0,\n"+
		"\t\t 0, 0, 0, 1, 0\n"+
		"\t}},\n").format(*m, name=name)


# compute and format them all
s=""
for name,colorMap in mappings.items():
	s+=formatColorMatrix(computeColorMatrix(colorMap), name)


# patch the Lua source
filename="../Engine/ColorBlindness.lua"
text=open(filename, "rt").read()

startText="\nlocal fixMatrix = {\n"
endText="}\n"
start=text.find(startText)
end=text.find(endText, start)

if start<0 or end<0: raise RuntimeError("Can't find place to insert to in the source")

open(filename, "wt").write(text[:start+len(startText)]+s+text[end:])
